<?php
get_header();
$productPage = get_post(KH_PRODUCT_PAGE);
set_query_var('thumbnail', get_the_post_thumbnail_url($productPage));
set_query_var('title', $productPage->post_title);
?>
<?php get_template_part("/inc/banner", null); ?>
<section class="section">
    <div class="flex justify-between items-center px-2 gap-8">
        <div>
            <h1 class="text-sm sm:text-base md:text-lg lg:text-xl text-kh_primary font-bold">
                <?php
                printf(
                    /* translators: %s: search query. */
                    esc_html__('Search Results for "%s"', 'textdomain'),
                    '<span>' . get_search_query() . '</span>'
                );
                ?>
            </h1>
        </div>
        <div class="relative max-w-[200px] sm:max-w-[250px] w-full">
            <form class="search-form" role="search" method="get" action="<?php echo esc_url(home_url('/')) ?>">
                <input type="hidden" name="post_type" value="<?= PRODUCT_POST_TYPE ?>" />
                <input class="border border-slate-200 py-1 sm:py-2 ps-4 pe-8 rounded text-sm lg:text-base w-full focus:outline-slate-300" type="search" placeholder="Searh..." name="s" value="<?= get_search_query() ?>">
                <button class="absolute right-2 top-1/2 translate-y-[-50%]">
                    <i class="fa-solid fa-magnifying-glass text-slate-600 text-sm sm:text-base"></i>
                </button>
            </form>
        </div>
    </div>

    <div class="grid grid-cols-2 lg:grid-cols-4 py-8">
        <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
                <?php get_template_part('/inc/productcard', null); ?>
            <?php endwhile; ?>
        <?php else : ?>
            <p class="text-center">No product found.</p>
        <?php endif; ?>
    </div>

    <div class="pagination flex justify-center">
        <?php
            the_posts_pagination(array(
                'prev_text' => __('Previous', 'textdomain'),
                'next_text' => __('Next', 'textdomain'),
            ));
        ?>
    </div>



</section>
<?php get_footer(); ?>