<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MTKN Cambodia</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" integrity="sha512-SnH5WK+bZxgPHs44uWIX+LLJAJ9/2PkPKZ5QiAj6Ta86w+fsb2TkcmfRyVX3pBnMFcV7oQPJkl9QevSCWr3W6A==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    <?php wp_head() ?>
    <style>
        #menu-main li.current-menu-item{
            color: #ED1B24 !important;
            text-decoration: underline !important;
        }

        .footer_menu .current-menu-item a{
            color: #f76c6c;
        }

        .wp-block-list{
        list-style-type: disc !important;
        margin-left: 20px !important;
    }

    .wp-block-list li{
        margin-bottom: 6px !important;
    }
    </style>
</head>


<body x-cloak x-data="productData()">
    <Header id="main-header" class="bg-white fixed top-0 left-0 w-full z-50 shadow" x-cloack x-data="{openNav: false}">
        <?php $setting = get_fields(KH_HOME_PAGE); ?>
        <div class="hidden lg:flex justify-between items-center py-2 kh_container">
            <a class="text-sm lg:text-base" href="mailto:<?= $setting['email']; ?>"><?= $setting['email'] ?></a>
            <div class="inline-flex gap-2 items-center">
                <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M164.9 24.6c-7.7-18.6-28-28.5-47.4-23.2l-88 24C12.1 30.2 0 46 0 64C0 311.4 200.6 512 448 512c18 0 33.8-12.1 38.6-29.5l24-88c5.3-19.4-4.6-39.7-23.2-47.4l-96-40c-16.3-6.8-35.2-2.1-46.3 11.6L304.7 368C234.3 334.7 177.3 277.7 144 207.3L193.3 167c13.7-11.2 18.4-30 11.6-46.3l-40-96z"/></svg>
                <a class="text-sm lg:text-base" href="tel:+<?= $setting['phone'] ?>">+<?= $setting['phone'] ?></a>
            </div>
        </div>
        <div class="py-2 sm:py-4 lg:py-6 bg-kh_secondary relative border">
            <div class="flex justify-between items-center gap-4 kh_container">
                <a href="/" class="w-20">
                    <img src="<?= bloginfo('template_url'); ?>/assets/images/mtkn-cambodia-logo.png" alt="logo">
                </a>

                <!-- Desktop Menu -->
                <Nav class="hidden lg:block">
                    <?php
                    wp_nav_menu([
                        'theme_location' => 'main',
                        'menu_class' => 'main_menu flex gap-4 items-center'
                    ]);
                    ?>
                </Nav>

                <!-- Mobile Menu -->
                <Nav id="mobile_menu" class="absolute top-[100%] left-0 w-full bg-white h-auto border shadow transition-all duration-200 ease-linear z-50" :class="openNav ? 'scale-y-1 origin-top' : 'scale-y-0 origin-top'">
                    <?php
                    wp_nav_menu([
                        'theme_location' => 'mobile',
                        'menu_class' => 'mobile_menu space-y-4 text-center py-4'
                    ]); ?>
                </Nav>

                <div class="relative">
                    <a href="/quotation/" class="py-2 px-6 bg-kh_primary text-white rounded text-xs hidden lg:block hover:bg-red-600">Get
                        A Quote</a>
                    <button class="inline-block lg:hidden" x-on:click="openNav = !openNav">
                        <svg class="w-5 h-5" x-show="!openNav" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M0 96C0 78.3 14.3 64 32 64l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 128C14.3 128 0 113.7 0 96zM0 256c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32zM448 416c0 17.7-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32s14.3-32 32-32l384 0c17.7 0 32 14.3 32 32z"/></svg>
                        <svg class="w-5 h-5" x-show="openNav" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"/></svg>
                    </button>
                    <span x-show="total !== 0" class="absolute -top-2 -right-[8px] bg-white px-2 py-0.5 rounded-full text-kh_primary hidden lg:block" x-text="total"></span>
                </div>
            </div>
        </div>
    </Header>