<?php

define("KH_HOME_PAGE", 8);
define("KH_SERVICE_PAGE", 27);
define("KH_ABOUT_PAGE", 25);
define("KH_CONTACT_PAGE", 14);
define("KH_PRODUCT_PAGE", 30);
define("KH_QUOTATION_PAGE", 216);
define("CONTACT_FORM_POST_TYPE", "contact-form");
define("SLIDER_POST_TYPE", "slider");
define("PRODUCT_POST_TYPE", "product");
define("EDUCATIONAL_POST_TYPE", "educational");
define("KH_PARTNER_TAXONOMIES", "partner");
define("KH_SERVICE_TAXONOMIES", "service");

function da_script()
{
    wp_enqueue_style("tialwind_css", get_template_directory_uri() . '/assets/src/output.css', array(), '');
    // wp_localize_script('custom-cf7', 'ajax_object', array(
    //     'ajaxurl' => admin_url('admin-ajax.php')
    // ));
}
add_action('wp_enqueue_scripts', 'da_script');

add_theme_support('post-thumbnails');
add_theme_support("menus");
add_post_type_support('page', 'excerpt');

function add_custom_class_to_menu_item($classes, $item, $args) {
    if (is_tax('services')) {
        $term = get_queried_object();
        if ($term && isset($term->slug)) {
            if (strpos($item->url, $term->slug) !== false) {
                $classes[] = 'current-menu-item';
            }
        }
    } else if (is_singular('product')) {
            $post_type_object = get_post_type_object('product');
            if ($post_type_object) {
                $slug = $post_type_object->rewrite['slug'];
                if (strpos($item->url, $slug) !== false) {
                    $classes[] = 'current-menu-item';
                }
            }
        }
    return $classes;
}
add_filter('nav_menu_css_class', 'add_custom_class_to_menu_item', 10, 3);

register_nav_menus(
    array(
        'main' => "Main",
        'mobile' => "Mobile",
        "footer" => "Footer"
    )
);

function custom_404_page()
{
    global $wp_query;
    if (!is_404()) {
        return;
    }
    $wp_query->set_404();
    status_header(404);
    get_template_part('404');
    exit();
}

add_action('template_redirect', 'custom_404_page');


function submit_quotation_form() {
    // Check for nonce security
    check_ajax_referer('my_nonce', 'nonce');

    $selectedItem = isset($_POST['selectedItem']) ? json_decode(stripslashes($_POST['selectedItem']), true) : [];
    $formData = isset($_POST['formData']) ? json_decode(stripslashes($_POST['formData']), true) : [];

    $formattedProduct = "Quantity - ( " . $formData['qty'] . " )\n\n";
        foreach ($selectedItem as $item) {
            $product_link = get_permalink($item['id']);
            $string = "Name: <a href=\"" . $product_link . "\"target='_blank'>" . $item['name'] . "</a>\n" . "Brand: " . $item['brand'] . "\n\n";
            $formattedProduct .= $string;
        }

    // Create a new post
    $quotation_post = array(
        'post_title'    => $formData['email'],
        'post_content'  => $formattedProduct,
        'post_status'   => 'private',
        'post_type'     => 'quotation-form'
    );

    // Insert the post into the database
    $post_id = wp_insert_post($quotation_post);

    if (!is_wp_error($post_id)) {
        // Update ACF fields
        update_field('name', sanitize_text_field($formData['name']), $post_id);
        update_field('email', sanitize_email($formData['email']), $post_id);
        update_field('phone', sanitize_text_field($formData['phone']), $post_id);
        update_field('organization', sanitize_text_field($formData['organization']), $post_id);
        update_field('message', sanitize_textarea_field($formData['message']), $post_id);

        wp_send_json_success('Quotation submitted successfully.');
    } else {
        wp_send_json_error('Failed to submit quotation.');
    }
    wp_die();
}

add_action('wp_ajax_submit_quotation_form', 'submit_quotation_form');
add_action('wp_ajax_nopriv_submit_quotation_form', 'submit_quotation_form');


function submit_contact_form() {
    check_ajax_referer('my_nonce', 'nonce');

    $formData = isset($_POST['contactForm']) ? json_decode(stripslashes($_POST['contactForm']), true) : [];

    $contact_post = array(
        'post_title' => $formData['email'],
        'post_content' => $formData['message'],
        'post_status' => 'private',
        'post_type' => CONTACT_FORM_POST_TYPE
    );

    $post_id = wp_insert_post($contact_post);

    if(!is_wp_error($post_id)) {
        update_field('name', sanitize_text_field($formData['first_name'] . ' ' . $formData['last_name']), $post_id);
        update_field('email', sanitize_email($formData['email']), $post_id);
        update_field('phone', sanitize_text_field($formData['phone']), $post_id);
        update_field('subject', sanitize_text_field($formData['subject']), $post_id);
        update_field('message', sanitize_textarea_field($formData['message']), $post_id);
        wp_send_json_success('Form submitted successfully');
    } else {
        wp_send_json_error('Failed to submit.');
    }
    wp_die();
}
add_action('wp_ajax_submit_contact_form', 'submit_contact_form');
add_action('wp_ajax_nopriv_submit_contact_form', 'submit_contact_form');

// another_way() {
//     add_action('wpcf7_before_send_mail', 'save_contact_form_to_acf');
//     function save_contact_form_to_acf($contact_form) {
//         $submission = WPCF7_Submission::get_instance();
//         if ($submission) {
//             $data = $submission->get_posted_data();

//             $post_id = wp_insert_post(array(
//                 'post_title' => sanitize_email($data['email']),
//                 'post_type' => CONTACT_FORM_POST_TYPE, 
//                 'post_status' => 'private',
//             ));

//             if ($post_id) {
//                 update_field('name', sanitize_text_field($data['first_name'] . ' ' . $data['last_name']), $post_id);
//                 update_field('email', sanitize_email($data['email']), $post_id);
//                 update_field('phone', sanitize_text_field($data['phone']), $post_id);
//                 update_field('subject', sanitize_text_field($data['subject']), $post_id);
//                 update_field('message', sanitize_textarea_field($data['message']), $post_id);
//             }
//         }
//     }
//     add_filter('wpcf7_skip_mail', 'skip_mail_sending');
//     function skip_mail_sending($skip_mail) {
//         return true;
//     }


//     function get_selected_products() {
//         // Check for nonce security
//         check_ajax_referer('my_nonce', 'nonce');

//         $ids = isset($_POST['ids']) ? $_POST['ids'] : array();

//         if (empty($ids)) {
//             wp_send_json_error('No IDs provided');
//             wp_die();
//         }

//         $posts = array();

//         foreach ($ids as $id) {
//             $post = get_post($id);
//             if ($post) {
//                 $posts[] = array(
//                     'id' => $post->ID,
//                     'title' => $post->post_title,
//                     'content' => $post->post_content,
//                     'thumbnail' => get_the_post_thumbnail_url($post->ID),
//                 );
//             }
//         }

//         wp_send_json_success($posts);
//         wp_die();
//     }

//     add_action('wp_ajax_get_selected_products', 'get_selected_products');
//     add_action('wp_ajax_nopriv_get_selected_products', 'get_selected_products');
// }

