<!-- 
Template Name: Services
-->

<?php
get_header(); 
$args = array(
    'taxonomy' => KH_SERVICE_TAXONOMIES,
    'hide_empty' => false,
    'parent' => 0,
    'order' => 'DESC',
    'orderby' => 'date',
);
$services = get_terms($args); 
$servicePage = get_post(KH_SERVICE_PAGE);
set_query_var('thumbnail', get_the_post_thumbnail_url());
set_query_var('title', $servicePage->post_title);
?>
<?php get_template_part('inc/banner', null); ?>

<section class="section">
    <div class="section-heading">
        <h1 class="section-title"><?= get_the_title() ;?></h1>
        <p class="section-intro"><?= get_the_excerpt() ;?></p>
    </div>
    <div class="grid grid-cols-2 xl:grid-cols-4 gap-4">
        <?php foreach($services as $service) :?>
            <?php set_query_var('service', $service) ?>
            <?php get_template_part('inc/service-card', null); ?>
        <?php endforeach ;?>
    </div>
</section>

<?php get_footer(); ?>