<?php
get_header();
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
$args = array(
    'post_type' => 'product',
    'posts_per_page' => 8,
    'paged' => $paged,
    'tax_query' => array(
        array(
            'taxonomy' => 'service',
            'field'    => 'slug',
            'terms'    => array('educational'),
            'operator' => 'NOT IN', 
        ),
    ),
);

$products = new WP_Query($args);
$productPage = get_post(KH_PRODUCT_PAGE);
set_query_var('thumbnail', get_the_post_thumbnail_url(KH_PRODUCT_PAGE));
set_query_var('title', $productPage->post_title);
$args = array(
    'taxonomy' => KH_SERVICE_TAXONOMIES,
    'hide_empty' => false,
    'order' => 'DESC',
    'orderby' => 'date',
    'parent' => 0
);
$services = get_terms($args);
$filtered_services = array_filter($services, function($term) {
    return $term->slug !== 'educational';
})
?>
<?php get_template_part("/inc/banner", null); ?>
<section x-data="{dropdown: false}" class="section">
    <div class="flex justify-between items-center px-2 gap-8">
        <div @click.away="dropdown = false" class="relative z-10">
            <button @click="dropdown = !dropdown" class="inline-block w-full h-full px-6 text-nowrap lg:px-12 py-2 bg-kh_primary text-white rounded text-xs sm:text-sm lg:text-base">By Category</button>
            <ul :class="dropdown ? 'scale-y-1' : 'scale-y-0'" class="absolute top-[110%] left-0 w-full h-auto kh_transition origin-top py-2 bg-white text-kh_primary shadow border border-slate-200 divide-y divide-slate-200">
                <a href="/products" class="block w-full h-full text-center hover:underline py-2 text-xs sm:text-sm lg:text-base">All</a>
                <?php foreach ($filtered_services as $service) : ?>
                    <a href="<?= get_category_link($service) ?>" class="block w-full h-full text-center hover:underline py-2 text-xs sm:text-sm lg:text-base"><?= $service->name; ?></a>
                <?php endforeach; ?>
            </ul>
        </div>
        <div class="relative max-w-[200px] sm:max-w-[250px] w-full">
            <form class="search-form" role="search" method="get" action="<?php echo esc_url(home_url('/')) ?>">
                <input type="hidden" name="post_type" value="<?= PRODUCT_POST_TYPE ?>" />
                <input class="border border-slate-200 py-1 sm:py-2 ps-4 pe-8 rounded text-sm lg:text-base w-full focus:outline-slate-300" type="search" placeholder="Search..." name="s" value="<?= get_search_query() ?>">
                <button class="absolute right-2 top-1/2 translate-y-[-50%]">
                    <i class="fa-solid fa-magnifying-glass text-slate-600 text-sm sm:text-base"></i>
                </button>
            </form>
        </div>
    </div>

    <?php if ($products->have_posts()) : ?>
        <div class="grid grid-cols-2 lg:grid-cols-4 py-8">
            <?php while ($products->have_posts()) : $products->the_post(); ?>
                <?php get_template_part('/inc/productcard', null); ?>
            <?php endwhile; ?>
        </div>
        <?php if ($products->max_num_pages > 1) : ?>
            <nav class="flex items-center">
                <div class="paginate-box">
                    <?php
                    $pagination_args = array(
                        'total' => $products->max_num_pages,
                        'current' => max(1, get_query_var('paged')),
                        'format' => 'page/%#%',
                        'show_all' => false,
                        'end_size' => 2,
                        'mid_size' => 1,
                        'prev_next' => true,
                        'prev_text' => __('Previous'),
                        'next_text' => __('Next'),
                        'type' => 'plain',
                    );

                    echo paginate_links($pagination_args);
                    ?>
                </div>
            </nav>
        <?php endif; ?>
    <?php else : ?>
        <div class="text-base sm:text-xl lg:text-3xl min-h-[400px] content-center text-center">No product found.</div>
    <?php endif; ?>


</section>
<?php get_footer(); ?>