<!-- 
Template Name: Contact Template
-->

<?php
get_header();
$servicePage = get_post(KH_CONTACT_PAGE);
set_query_var('thumbnail', get_the_post_thumbnail_url());
set_query_var('title', $servicePage->post_title);
?>

<?php get_template_part('inc/banner', null); ?>
<p class="text-xs sm:text-sm md:text-base fixed bottom-4 w-[80%] max-w-[500px] bg-green-500 text-white px-4 py-2 rounded z-50 kh_transition" :class="contact_successMessage ? 'right-4' : 'right-[-100%]'">
    Form has been successfully send.
</p>
<section class="section space-y-8">
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
        <section class="w-full h-auto border border-slate-300 px-4 py-8 rounded shadow-sm relative">
            <?php get_template_part('/inc/forms/contact-form', null) ;?>
        </section>

        <section class="w-full h-fit relative border-slate-700 overflow-hidden">
            <div>
                <div class="mb-8">
                    <a href="/">
                        <img class="w-32" src="<?= bloginfo('template_url'); ?>/assets/images/mtkn-cambodia-logo.png" alt="">
                    </a>
                </div>
                <div class="grid grid-cols-4 gap-4 mb-2 lg:mb-4">
                    <span>Address</span>
                    <a class="col-span-3 lg:col-span-2" href="https://maps.app.goo.gl/RM5goy3C8EVRCsvHA" target="_blank">No.408, Tower(B), Myaing Hay Wun Condo, 8th Miles Mayangone Township, Yangon, Myanmar.</a>
                </div>
                <div class="grid grid-cols-4 gap-4 mb-2 lg:mb-4">
                    <span>Email</span>
                    <a class="col-span-3 lg:col-span-2" href="mailto:myintthukhanadicambodia@gmail.com">myintthukhanadicambodia@gmail.com</a>
                </div>
                <div class="grid grid-cols-4 gap-4 mb-2 lg:mb-4">
                    <span>Phone</span>
                    <a class="col-span-3 lg:col-span-2" href="tel:+0912456987">+959 12456987</a>
                </div>
            </div>
            <div class="mt-8">
                <iframe class="w-full h-[230px] sm:h-[300px]" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3818.0536071278616!2d96.14093487580335!3d16.87324251741157!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x30c1947d66ea7343%3A0x76517d9ff32c0eda!2sMyint%20Thukha%20Nadi%20Co.%2CLtd!5e0!3m2!1sen!2smm!4v1719470755524!5m2!1sen!2smm" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div>
        </section>
    </div>

</section>
<?php get_footer(); ?>