<?php
get_header();
$productPage = get_post(KH_PRODUCT_PAGE);
$terms = get_the_terms($post->ID, 'service');
$brand = get_the_terms($post->ID, 'partner');
$related_products = [];
if ($terms && !is_wp_error($terms)) {
    $term_ids = wp_list_pluck($terms, 'term_id');
    $related_args = array(
        'post_type' => PRODUCT_POST_TYPE,
        'posts_per_page' => 3,
        'orderby' => 'rand',
        'post__not_in' => array($post->ID),
        'tax_query' => array(
            array(
                'taxonomy' => 'service',
                'field' => 'term_id',
                'terms' => $term_ids,
            ),
        ),
    );
    $related_products = new WP_Query($related_args);
}
$postData = [
    'id' => $post->ID,
    'name' => $post->post_title,
    'slug' => $post->post_slug,
    'brand' => $brand[0]->name
];
$json_postdata = json_encode($postData);
?>
<?php if ($terms[0]->slug !== 'educational') : ?>

    <?php
    set_query_var('thumbnail', get_the_post_thumbnail_url($productPage));
    set_query_var('title', $productPage->post_title);
    get_template_part("/inc/banner", null);
    get_template_part("/inc/breadcrumb", null);; ?>
    <section class="section">
        <div class="max-w-[1080px] mx-auto">
            <div class="grid grid-cols-1 md:grid-cols-6 gap-8 border-b border-slate-700 py-8">
                <div class="col-span-1 md:col-span-2">
                    <div class="max-w-[350px] w-full mx-auto">
                        <img class="border border-slate-200 aspect-[7/5]" src="<?= get_the_post_thumbnail_url($post) ?>" alt="<?= $post->name ?>">
                    </div>
                </div>
                <div class="col-span-1 md:col-span-4">
                    <?php foreach ($brand as $partner) : ?>
                        <em class="text-sm text-slate-500 font-semibold"><?= $partner->name; ?></em>
                    <?php endforeach ?>
                    <h1 class="text-lg sm:text-xl md:text-2xl lg:text-4xl font-bold mb-4 sm:mb-8"><?= $post->post_title ?></h1>
                    <?php foreach ($terms as $term) : ?>
                        <div class="text-xs sm:text-sm text-end text-slate-800 lg:text-kh_primary font-semibold mb-4 px-4"><span class="hidden lg:inline text-slate-700">Category - </span> <a href="<?= get_category_link($term) ?>"><?= $term->name; ?></a></div>
                    <?php endforeach ?>
                    <div class="text-xs sm:text-sm lg:text-base text-slate-600 mb-8"><?= the_content() ?></div>
                    <div class="text-center lg:text-start flex gap-4">
                        <button @click='toggle(<?php echo $json_postdata; ?>)' class="w-[150px] text-center block py-2 text-xs sm:text-sm lg:text-base rounded-lg text-white active:scale-95 transition-all duration-100 ease-linear" :class="selectedItem.some(item => item.id === <?php echo $postData['id'] ?>) ? 'bg-kh_primary' : 'bg-green-600'" x-text="selectedItem.some(item => item.id === <?php echo $postData['id'] ?>) ? 'Remove From List' : 'Add To List'">
                        </button>
                        <a href="/quotation" class="text-center text-slate-700 block lg:hidden border-b border-dotted border-slate-700 text-xs sm:text-sm lg:text-base">Go to list</a>
                    </div>
                </div>
            </div>
            <?php if ($related_products->have_posts()) : ?>
                <div class="py-4 mt-12">
                    <h1 class="text-xl lg:text-2xl text-center font-bold text-slate-800 tracking-wide mb-6">Related Products</h1>
                    <div class="grid grid-cols-3 gap-0 sm:gap-2 lg:gap-4">
                        <?php while ($related_products->have_posts()) : $related_products->the_post(); ?>
                            <?php get_template_part('inc/productcard', null); ?>
                        <?php endwhile; ?>
                        <?php wp_reset_postdata(); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </section>
<?php else : ?>
    <?php
    set_query_var('thumbnail', get_the_post_thumbnail_url());
    set_query_var('title', 'Educational');
    get_template_part("/inc/banner", null);; ?>
    <section class="section">
        <div class="">
            <h3 class="text-base sm:text-lg lg:text-2xl xl:text-4xl text-center underline underline-offset-8 uppercase mb-8 font-bold"><?= get_the_title(); ?></h3>
            <p><?= get_the_content() ?></p>
        </div>
    </section>
<?php endif; ?>


<?php get_footer(); ?>