<?php
$args = array(
    'taxonomy' => KH_SERVICE_TAXONOMIES,
    'hide_empty' => false,
    'order' => 'DESC',
    'orderby' => 'date',
    'parent' => 0
);
$services = get_terms($args); 
?>

<section class="section">
    <div class="section-heading">
        <h1 class="section-title">Our Services</h1>
        <p class="section-intro">Lorem ipsum dolor, sit amet consectetur adipisicing elit. Porro aut, voluptatibus facilis sequi repellat deserunt repudiandae eveniet perspiciatis ullam minus.</p>
    </div>

    <div id="service-cards" class="grid grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-4 lg:gap-8">
            <?php foreach ($services as $service) : ?>
                <a href="<?= get_category_link($service) ?>" class="p-2 sm:p-4 lg:p-8 rounded-lg shadow-lg hover:shadow-2xl border border-slate-200 space-y-4 sm:space-y-6 lg:space-y-8 group block kh_transition">
                    <div class="flex justify-center">
                        <?= get_field('icon_path', $service) ?>
                    </div>
                    <h3 class="font-bold text-center tracking-wide text-xs sm:text-base lg:text-lg group-hover:text-kh_primary"><?= $service->name ;?></h3>
                    <p class="leading-6 sm:leading-[32px] lg:leading-[32px] text-[10px] sm:text-sm lg:text-base text-center text-slate-700 font-semibold">
                        <?= get_field('intro', $service) ?>
                    </p>
                </a>
            <?php endforeach; ?>
    </div>
</section>