<?php
$args = array(
    'post_type' => PRODUCT_POST_TYPE,
    'posts_per_page' => 3,
);

$products = new WP_Query($args);
?>

<section class="section overflow-hidden">
    <div class="section-heading">
        <h1 class="section-title">Our Products</h1>
    </div>
    <div class="w-full product-swiper relative overflow-hidden">
        <div class="swiper-wrapper flex items-center">
            <?php if ($products->have_posts()) : while ($products->have_posts()) : $products->the_post(); ?>
                <?php get_template_part('/inc/productcard', null) ;?>    
            <?php endwhile; ?>
            <?php else :?>
                <p>No product found.</p>
            <?php endif; ?>
            
        </div>


        <!-- <div class="swiper-button-prev shadow-md"></div> -->
        <div class="swiper-button-next shadow-md active:scale-80 transition-all duration-100 ease-linear"></div>
    </div>
</section>
