<form @submit.prevent="submitForm">
    <h2 class="text-center text-base sm:text-lg lg:text-2xl xl:text-4xl font-bold text-orange-400 mb-8">Quotation Form</h2>
    <section class="mx-auto">
        <h6 class="text-slate-800 underline underline-offset-8 mb-4 lg:mb-8 font-semibold">Selected Products</h6>
        <div>
            <table class="table-auto w-full text-center border-collapse border border-slate-300 text-[10px] sm:text-xs lg:text-base">
                <thead class="bg-gray-400">
                    <tr>
                        <th class="max-w-[30px] py-3 px-2 border-x border-slate-300">No.</th>
                        <th class="py-3 px-2 border-x border-slate-300">Name</th>
                        <th class="py-3 px-2 border-x border-slate-300">Brand</th>
                        <th class="py-3 px-2 border-x border-slate-300">Remove</th>
                    </tr>
                </thead>
                <tbody>
                    <template x-if="selectedItem.length > 0">
                        <template x-for="(value, index) in selectedItem">
                            <tr key="index" class="border-collapse">
                                <td class="max-w-[30px] border border-slate-300 py-2 px-2" x-text="index + 1 + '.'"></td>
                                <td class="hover:underline cursor-pointer border border-slate-300 py-2 px-1 lg:px-2" x-text="value.name"></td>
                                <td class="hover:underline cursor-pointer border border-slate-300 py-2 px-1 lg:px-2" x-text="value.brand"></td>
                                <td class="hover:underline cursor-pointer border border-slate-300 py-2 px-2">
                                    <button @click="toggle(value)">
                                    <svg style="width: 14px; height: 14px; fill: red" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"/></svg>
                                    </button>
                                </td>
                            </tr>
                        </template>
                    </template>
                    <template x-if="selectedItem.length <= 0">
                        <th class="p-4 text-center w-full font-normal" colspan="5">
                            <p>No Product Selected</p>
                            <span x-show="errors.products" x-text="errors.products" class="text-red-600 text-xs sm:text-sm lg:text-base"></span>
                        </th>    
                    </template>
                </tbody>
            </table>
            <div class="text-end">
                <div class="flex gap-4 justify-end items-center my-2">
                    <label for="quantity" class="font-semibold inline-block text-xs sm:text-sm lg:text-base">Quantity</label>
                    <input id="quantity" type="number" value="1" x-model="formData.qty" required class="border border-slate-300 focus:outline-none block max-w-[60px] lg:max-w-[80px] text-center text-xs sm:text-sm lg:text-base">
                </div>
                <span x-show="errors.qty" x-text="errors.qty" class="text-red-600 text-xs sm:text-sm"></span>
            </div>
        </div>
    </section>
    <hr class="my-8">
    <section class="mx-auto text-xs sm:text-sm lg:text-base">
        <h6 class="text-slate-800 underline underline-offset-8 mb-4 lg:mb-8 font-semibold text-base">Contact Information</h6>
        <div class="flex gap-4 mb-4">
            <div class="w-full">
                <label for="name">Name</label>
                <input id="name" type="text" placeholder="Name" class="border border-slate-300 w-full py-1 px-2 focus:outline-none text-xs lg:text-base" x-model="formData.name" required>
                <span x-show="errors.name" x-text="errors.name" class="text-red-600 text-xs sm:text-sm lg:text-base"></span>
            </div>
            <div class="w-full">
                <label for="email">Email</label>
                <input id="email" type="text" placeholder="Email" class="border border-slate-300 w-full py-1 px-2 focus:outline-none text-xs lg:text-base" x-model="formData.email" required>
                <span x-show="errors.email" x-text="errors.email" class="text-red-600 text-xs sm:text-sm lg:text-base"></span>
            </div>
        </div>
        
        <div class="flex gap-4 mb-4">
            <div class="w-full">
                <label for="phone">Phone Number</label>
                <input id="phone" type="text" placeholder="+959123456789" pattern="^\+?[0-9]+$" class="border border-slate-300 w-full py-1 px-2 focus:outline-none text-xs lg:text-base" x-model="formData.phone" required>
                <span x-show="errors.phone" x-text="errors.phone" class="text-red-600 text-xs sm:text-sm lg:text-base"></span>
            </div>
            <div class="w-full">
                <label for="organization">Organization</label>
                <input id="organization" type="text" placeholder="Organization" class="border border-slate-300 w-full py-1 px-2 focus:outline-none text-xs lg:text-base" x-model="formData.organization" required>
                <span x-show="errors.organization" x-text="errors.organization" class="text-red-600 text-xs sm:text-sm lg:text-base"></span>
            </div>
        </div>
        <div class="mb-4">
            <label for="message" class="block">Message</label>
            <textarea name="message" id="message" rows="5" class="w-full border border-slate-300 focus:outline-none p-2 text-xs lg:text-base" x-model="formData.message" required></textarea>
            <span x-show="errors.message" x-text="errors.message" class="text-red-600 text-xs sm:text-sm lg:text-base"></span>
        </div>
    </section>
    <div class="pt-8 py-4 text-center">
        <button class="w-[150px] text-center text-xs sm:text-sm lg:text-base py-2 bg-orange-500 text-white font-semibold rounded active:scale-95 transition-all duration-100 ease-linear hover:bg-orange-600">
            Send
        </button>
    </div>
</form>