<?php
$paged    = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
$per_page = '3';
$offset   = ( $paged - 1 ) * $per_page;
$args     = array(
	'post_type'      => THAI_PRODUCT_POST_TYPE,
	'posts_per_page' => $per_page,
	'offset'         => $offset,
	'page'           => $paged,
);
$products = new WP_Query( $args );
?>
    <section class="body-font mx-auto max-w-[69rem]">
        <div class="container px-5 mx-auto py-14">
			<?php if ( is_archive( 'product' ) ) : ?>
                <div class="flex flex-wrap mb-8 justify-between">
                    <h1 class="text-xl font-semibold uppercase ml-2">Products</h1>
					<?php get_template_part( 'inc/search-form', null ); ?>
                </div>
			<?php endif; ?>
            <div class="grid grid-cols-2 lg:grid-cols-3 gap-4">
				<?php while ( $products->have_posts() ) : $products->the_post(); ?>
                    <div class="w-full max-w-[380px] mx-auto overflow-hidden">
                        <a href="<?php the_permalink(); ?>" class="relative block group overflow-hidden h-[300px] min-[550px]:h-[420px] sm:h-[450px] ">
                            <div class="absolute w-full h-full top-0 bg-dark lg:opacity-0 lg:group-hover:opacity-30 opacity-30 left-0 z-10 rounded-lg"></div>
                            <img alt="<?= the_title() ?>" src="<?php the_post_thumbnail_url(); ?>"
                                 class="absolute inset-0 object-cover w-full h-full transition-opacity rounded-xl border border-slate-300"/>
                            <div class="relative p-4 sm:p-6 lg:p-8 z-20 lg:group-hover:opacity-100 lg:opacity-0 h-full">
                                <p class="text-sm font-medium tracking-widest uppercase text-mtkn-yellow">
                                    Products
                                </p>
                                <p class="text-base font-bold text-white sm:text-2xl z-20"><?php the_title(); ?></p>
                                <div class="text-white text-[8px] sm:text-sm leading-[16px] sm:leading-[24px] max-h-[105px] overflow-hidden absolute bottom-4 lg:-bottom-[100%] left-0 px-2 sm:py-2 py-2 lg:group-hover:bottom-4 transition-all duration-500 ease-linear"><?php the_excerpt(); ?></div>
                            </div>
                        </a>
                    </div>
				<?php endwhile; ?>
            </div>
        </div>
    </section>
<?php if ( is_archive( 'product' ) ) : ?>
	<?php get_template_part( 'inc/pagination', null, array( 'services' => $products ) ); ?>
<?php endif; ?>