<?php 
get_header();  
$product = get_post();
$terms = get_the_terms( $product->ID, 'brand' );
$featured_img = wp_get_attachment_url(get_post_thumbnail_id($product->ID));
?>

<?php get_template_part('template-parts/section-breadcrumb', null); ?>

<section class="overflow-hidden text-gray-600 body-font">
  <div class="container px-5 py-24 mx-auto">
    <div class="flex flex-wrap mx-auto lg:w-4/5">
      <img alt="ecommerce" class="object-fill object-center w-full h-100 rounded-xl lg:w-1/2 lg:h-100" src="<?php echo $featured_img; ?>" style="max-width: 300px">
      <div class="w-full mt-6 lg:w-1/2 lg:pl-10 lg:py-6 lg:mt-0">
        <h2 class="text-sm tracking-widest text-gray-500 title-font">
            <?php foreach ($terms as $term) :  ?>
                <?= $term->name; ?>
            <?php endforeach; ?>
        </h2>
        <h1 class="mb-1 text-3xl font-medium text-gray-900 title-font"><?php the_title(); ?></h1>
        <p class="my-3 leading-relaxed"><?php the_content(); ?></p>
        <!-- <div class="pb-5 mt-3 mb-5 border-b-2 border-gray-100"></div>
        <div class="flex">
          <span class="text-2xl font-medium text-gray-900 title-font">$58.00</span>
          <button class="flex px-6 py-2 ml-auto text-sm text-white transition border-0 rounded focus:outline-none bg-mtkn-blue hover:bg-mtkn-yellow hover:text-mtkn-blue">Buy</button>
        </div> -->
      </div>
    </div>
  </div>
</section>

<?php get_template_part('template-parts/section-related-products', null); ?>

<?php get_footer(); ?>