<?php
get_header();
$r_posts = get_posts();
$post = get_post();
$index = 1;
?>

<?php get_template_part('template-parts/section-breadcrumb', null); ?>

    <section class="px-5 py-10">
        <div class="container grid grid-cols-12 mx-auto max-w-[90rem] gap-y-6 md:gap-10">
            <div class="relative flex-col col-span-12 py-4 bg-center bg-no-repeat bg-cover min-h-96 md:col-span-8 ">
                <img class="object-cover rounded-xl w-full mb-3 h-96" src="<?php echo get_the_post_thumbnail_url() ?>" alt=""/>
                <?php foreach (get_the_category($post->ID) as $cat) : ?>
                    <a href="<?= get_category_link($cat->term_id); ?>"
                       class="relative z-10 rounded-full bg-gray-50 px-3 py-1.5 font-medium text-gray-600  hover:bg-mtkn-yellow"><?= $cat->name; ?></a>
                <?php endforeach; ?>
                <h1 class="my-4 text-4xl font-semibold uppercase"><?php the_title(); ?></h1>
                <div class="prose max-w-none"><?php the_content(); ?></div>
            </div>
            <!--  blog latest posts  -->
            <div class="hidden col-span-4 py-2 sm:hidden md:block lg:col-span-4 xl:col-span-4">
                <?php get_template_part('inc/category-post', null); ?>
                <?php get_template_part('inc/top-post', null, array('r_posts'=>$r_posts, 'index'=>$index)); ?>
            </div>
        </div>
    </section>

<?php get_footer(); ?>