<?php

const THAI_SERVICE_POST_TYPE = "service";
const THAI_SLIDER_POST_TYPE = "slider";
const THAI_PRODUCT_POST_TYPE = "product";
const THAI_CONTACT_POST_TYPE = "contact-forms";

const THAI_HOME_PAGE = 6;
const THAI_ABOUT_US_PAGE = 8;
const THAI_CONTACT_US_PAGE = 10;
const THAI_BLOG_PAGE = 171;
const THAI_BRANDS_PAGE = 248;
const THAI_SERVICES_PAGE = 254;

// slider getting data
$args = [
    'numberposts' => -1,
    'post_type' => THAI_SLIDER_POST_TYPE,
];
$sliders = get_posts($args);
foreach ($sliders as $key => $slider) {
    $slide_menu[$key] = [
        'icon' => get_fields($slider)['service_logo'],
        'name' => get_fields($slider)['service_name'],
        'description' => get_fields($slider)['service_description'],
    ];
    $side_menuarray[$key] = [
        get_fields($slider)['service_logo'],
        get_fields($slider)['service_name'],
        get_fields($slider)['service_description'],
    ];
}
$logged = is_user_logged_in();

/**
 * Enqueue scripts and styles.
 */
function enqueue_swiper_scripts()
{
    wp_enqueue_script('swiper-js', 'https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.js', array('jquery'), '8', true);
    wp_enqueue_style('swiper-css', 'https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css', array(), '8', 'all');
}

add_action('wp_enqueue_scripts', 'enqueue_swiper_scripts');

function scripts()
{
    global $slide_menu;
    global $logged;
    wp_enqueue_style('mtkn-thailand-style', get_template_directory_uri() . '/assets/css/output.css', array(), '1.0');

    wp_enqueue_script('alpine-js', 'https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js', array(), '3.0.0', true);
    wp_enqueue_script('jquery', get_template_directory_uri() . '/assets/js/jquery-3.6.2.min.js');
    wp_enqueue_script('main', get_template_directory_uri() . '/assets/js/main.js', '', '', true);
    wp_script_add_data('main', 'type', 'module');
    wp_enqueue_script('app', get_template_directory_uri() . '/assets/js/app.js', '', '1.0', true);
    wp_localize_script('app', 'myData', ['menu' => $slide_menu, 'logged' => $logged]);
}

add_action('wp_enqueue_scripts', 'scripts');

function remove_category_base($category_link)
{
    $category_link = str_replace('/category/', '/', $category_link);
    return $category_link;
}
add_filter('category_link', 'remove_category_base');

/* 404 */
function custom_404_page()
{
    global $wp_query;
    if (!is_404()) {
        return;
    }
    $wp_query->set_404();
    status_header(404);
    get_template_part('404');
    exit();
}

add_action('template_redirect', 'custom_404_page');

// products pagination post per page
function product_posts_per_page($query)
{
    if (isset($query->query_vars['post_type']))
        if ($query->query_vars['post_type'] == 'product') $query->query_vars['posts_per_page'] = 3;
    return $query;
}

if (!is_admin()) add_filter('pre_get_posts', 'product_posts_per_page');

// custom menu
function clean_custom_menus()
{
    $menu_name = 'main'; // specify custom menu name
    if (($locations = get_nav_menu_locations()) && isset($locations[$menu_name])) {
        $menu = wp_get_nav_menu_object($locations[$menu_name]);
        $menu_items = wp_get_nav_menu_items($menu->term_id);

        $menu_list = '<div class="hidden w-full lg:block lg:w-auto">' . "\n";
        $menu_list .= "\t\t\t\t" . '<ul id="menu-main" class="flex flex-col p-4 mt-4 border border-gray-100 rounded-lg lg:flex-row lg:space-x-4 lg:mt-0 lg:text-sm lg:font-medium lg:border-0">' . "\n";
        $actual_link = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
        foreach ((array)$menu_items as $key => $menu_item) {
            $title = $menu_item->title;
            $url = $menu_item->url;
            $crumbs = explode("/", $_SERVER["REQUEST_URI"]);
            $url_crumbs = explode("/", $url);
            if ($actual_link == $url) {
                $menu_list .= "\t\t\t\t\t" . '<a id="menu-item-' . $menu_item->ID . '" class="nav-link current-menu-item special_nav_class menu-item menu-item-type-post_type menu-item-object-page menu-item-' . $menu_item->ID . ' block py-2 pl-3 pr-4 hover:text-mtkn-yellow cursor-pointer" href="' . $url . '"><li>' . $title . '</li></a>' . "\n";
            } else if ($url_crumbs[3] == $crumbs[1]) {
                $menu_list .= "\t\t\t\t\t" . '<a id="menu-item-' . $menu_item->ID . '" class="nav-link current-menu-item special_nav_class menu-item menu-item-type-post_type menu-item-object-page menu-item-' . $menu_item->ID . ' block py-2 pl-3 pr-4 hover:text-mtkn-yellow cursor-pointer" href="' . $url . '"><li>' . $title . '</li></a>' . "\n";
            } else {
                $menu_list .= "\t\t\t\t\t" . '<a id="menu-item-' . $menu_item->ID . '" class="nav-link special_nav_class menu-item menu-item-type-post_type menu-item-object-page menu-item-' . $menu_item->ID . ' block py-2 pl-3 pr-4 hover:text-mtkn-yellow cursor-pointer" href="' . $url . '"><li>' . $title . '</li></a>' . "\n";
            }
        }
        $menu_list .= "\t\t\t\t" . '</ul>' . "\n";
        $menu_list .= "\t\t\t" . '</div>' . "\n";
    } else {
        // $menu_list = '<!-- no list defined -->';
    }
    echo $menu_list;
}

// custom mobile menu 
function clean_custom_mobile_menus()
{
    $menu_name = 'mobile';
    if (($locations = get_nav_menu_locations()) && isset($locations[$menu_name])) {
        $menu = wp_get_nav_menu_object($locations[$menu_name]);
        $menu_items = wp_get_nav_menu_items($menu->term_id);

        $menu_list = '<div class="w-[100%] mx-auto text-center">' . "\n";
        $menu_list .= "\t\t\t\t" . '<ul id="menu-mobile-menu" class="">' . "\n";
        $actual_link = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
        foreach ((array)$menu_items as $key => $menu_item) {
            $title = $menu_item->title;
            $url = $menu_item->url;
            $crumbs = explode("/", $_SERVER["REQUEST_URI"]);
            $url_crumbs = explode("/", $url);
            if ($actual_link == $url) {
                if ($url_crumbs[3] !== 'blog') {
                    $menu_list .= "\t\t\t\t\t" . '<li id="menu-item-' . $menu_item->ID . '" class="current-menu-item special_nav_class menu-item menu-item-type-post_type menu-item-object-page menu-item-' . $menu_item->ID . ' rounded-lg text-3xl font-bold tracking-tight mt-3 mb-6 menu-mobile-menu hover:text-mtkn-yellow" ><a href="' . $url . '" class="block nav-link">' . $title . '</a></li>' . "\n";
                } else {
                    $menu_list .= "\t\t\t\t\t" . '<span class="seperator"></span> <li id="menu-item-' . $menu_item->ID . '" class="current-menu-item special_nav_class menu-item menu-item-type-post_type menu-item-object-page menu-item-' . $menu_item->ID . ' rounded-lg  text-3xl font-bold tracking-tight mt-3 mb-6  menu-mobile-menu hover:text-mtkn-yellow" ><a href="' . $url . '" class="block nav-link">' . $title . '</a></li>' . "\n";
                }
            } else if ($url_crumbs[3] == $crumbs[1]) {
                if ($url_crumbs[3] !== 'blog') {
                    $menu_list .= "\t\t\t\t\t" . '<li id="menu-item-' . $menu_item->ID . '" class="current-menu-item special_nav_class menu-item menu-item-type-post_type menu-item-object-page menu-item-' . $menu_item->ID . ' rounded-lg  text-3xl font-bold tracking-tight mt-3 mb-6  menu-mobile-menu hover:text-mtkn-yellow" ><a href="' . $url . '" class="block nav-link">' . $title . '</a></li>' . "\n";
                } else {
                    $menu_list .= "\t\t\t\t\t" . '<span class="seperator"></span> <li id="menu-item-' . $menu_item->ID . '" class="current-menu-item special_nav_class menu-item menu-item-type-post_type menu-item-object-page menu-item-' . $menu_item->ID . ' rounded-lg  text-3xl font-bold tracking-tight mt-3 mb-6  menu-mobile-menu hover:text-mtkn-yellow" ><a href="' . $url . '" class="block nav-link">' . $title . '</a></li>' . "\n";
                }
            } else if ($url_crumbs[3] == 'blog') {
                $menu_list .= "\t\t\t\t\t" . '<span class="seperator"></span> <li id="menu-item-' . $menu_item->ID . '" class=" special_nav_class menu-item menu-item-type-post_type menu-item-object-page menu-item-' . $menu_item->ID . ' rounded-lg  text-3xl font-bold tracking-tight mt-3 mb-6  menu-mobile-menu hover:text-mtkn-yellow" ><a href="' . $url . '" class="block nav-link">' . $title . '</a></li>' . "\n";
            } else {
                $menu_list .= "\t\t\t\t\t" . '<li id="menu-item-' . $menu_item->ID . '" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-' . $menu_item->ID . ' rounded-lg text-3xl font-bold tracking-tight mt-3 mb-6  menu-mobile-menu  hover:text-mtkn-yellow" ><a href="' . $url . '" class="block nav-link">' . $title . '</a></li>' . "\n";
            }
        }
        $menu_list .= "\t\t\t\t" . '</ul>' . "\n";
        $menu_list .= "\t\t\t" . '</div>' . "\n";
    } else {
    }
    echo $menu_list;
}

/* search from */
function searchfilter($query) {
    if ($query->is_search && !is_admin() ) {
        if(isset($_GET['post_type'])) {
            $type = $_GET['post_type'];
            if($type == 'product') {
                $query->set('post_type',array('product'));
//                $query->set( 'tax_query', array(
//                    array(
//                        'taxonomy' => 'brand',
//                        'field' => 'slug',
//                        'terms' => get_query_var( 's' )
//                    )
//                ) );
            }   
        }
    }
    return $query;
}
add_filter('pre_get_posts','searchfilter');

function show_all_products( $query ) {
    if ( !is_admin() && $query->is_main_query() && is_post_type_archive( 'product' ) && isset($_GET['s']) && empty($_GET['s']) ) {
        $query->set( 'posts_per_page', '6');
        $query->set('orderby', 'rand');
    }
}
add_action( 'pre_get_posts', 'show_all_products' );

// login logo
function custom_login_logo()
{
    echo "
	<style>
		body.login #login h1 a {
		background:	url('" . get_bloginfo('template_url') . "/assets/images/logo-small.png') no-repeat center;
		width: auto;
		height: 100px;
		}
	</style>;";
}

add_action("login_head", "custom_login_logo");

//add class to a tag in footer nav
function add_class_to_all_menu_anchors($ats)
{
    $ats['class'] = 'text-white transition hover:text-mtkn-yellow';
    return $ats;
}

add_filter('nav_menu_link_attributes', 'add_class_to_all_menu_anchors', 10);

################################################################################
// Admin customisation
// give clean admin look for the client
################################################################################
function customise_dashboard()
{
    if (is_user_logged_in()) {
        global $current_user;
        if ($current_user->user_login != 'admin') {
            add_action('admin_menu', 'remove_menu_items', 999);
            add_action('admin_menu', 'remove_submenus');
            add_action('wp_dashboard_setup', 'remove_dashboard_widgets');
            add_action('admin_menu', 'remove_menu_for_low_level_user');
        } else {
            add_action('admin_menu', 'remove_superadmin_menu');
        }
        if (!current_user_can('administrator')) {
            add_action('admin_bar_menu', 'remove_admin_bar', 100);
        }
    }
}

add_action('init', 'customise_dashboard');

function remove_superadmin_menu()
{
    remove_menu_page('ot-settings');
}

function remove_admin_bar()
{
    global $wp_admin_bar;
    $wp_admin_bar->remove_menu('my-sites');
    $wp_admin_bar->remove_menu('wpseo-menu');
    $wp_admin_bar->remove_menu('new-content');
}

function remove_menu_for_low_level_user()
{
    remove_menu_page('index.php');
    $ban_post_type_menu = array("acf-field-group");
    foreach ($ban_post_type_menu as $m) {
        remove_menu_page('edit.php?post_type=' . $m);
    }
}

//flush_rewrite_rules( true );
function remove_menu_items()
{
    global $menu;
    $restricted = array(__('Links'), __('Plugins'), __('Tools'), __('SEO'), __('Option Tree'), __('Users'), __('Settings'), __('Comments'), __('Options'), __('Currencyr'));
    end($menu);
    while (prev($menu)) {
        $value = explode(' ', $menu[key($menu)][0]);
        if (in_array($value[0] != NULL ? $value[0] : "", $restricted)) {
            unset($menu[key($menu)]);
        }
    }
    //remove custom plugin menu
    $restricted_plug_menu = array(
        'wpseo_dashboard', 'ot-settings', 'wpcf7', 'toolset-dashboard', 'Wordfence', 'wpfastestcacheoptions'
    );
    foreach ($restricted_plug_menu as $m) {
        remove_menu_page($m);
    }
}

function remove_submenus()
{
    global $submenu;
    unset($submenu['index.php'][10]); // Removes 'Updates'.
    unset($submenu['themes.php'][5]); // Removes 'Themes'.
    unset($submenu['themes.php'][7]); // Removes 'Widgets'.
    unset($submenu['edit.php'][16]); // Removes 'Tags'.  
    remove_action('admin_menu', '_add_themes_utility_last', 101); //remove editor under appearance
}

function remove_dashboard_widgets()
{
    global $wp_meta_boxes;
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_plugins']);
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_recent_comments']);
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_primary']);
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_incoming_links']);
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_recent_drafts']);
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_secondary']);
    //unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_quick_press']); 
}

function my_admin_footer_text($default_text)
{
    return '<span id="footer-thankyou">Website managed and developed by <a href="#" target="_blank">Thet Naing Soe</a><span> | Powered by <a href="http://www.wordpress.org">WordPress</a>';
}

add_filter('admin_footer_text', 'my_admin_footer_text');

//for adding menu in adimin panle under Apperance->Menu
add_theme_support('menus');
add_theme_support('post-thumbnails');

//register menu//
register_nav_menus(
    array(
        'main' => 'Main',
        'mobile' => 'Mobile Menu',
        'footer' => 'Footer Menu',
        'footer_service' => 'Footer Service Menu',
    )
);


////ajax url/////
function javascript_variables()
{ ?>
    <script type="text/javascript">
        var ajax_url = '<?php echo admin_url("admin-ajax.php"); ?>';
        var ajax_nonce = '<?php echo wp_create_nonce("secure_nonce_name"); ?>';
    </script><?php
}

add_action('wp_head', 'javascript_variables');

/* contact form submit */
function contact_form()
{
    check_ajax_referer('secure_nonce_name', 'security');

    $errors = [];
    $data = [];

    if (empty($_POST["name"])) {
        $errors['name'] = 'Name is required.';
    }
    if (!filter_var($_POST["email"], FILTER_VALIDATE_EMAIL)) {
        $errors['email'] = 'Email is required.';
    }
    if (empty($_POST["subject"])) {
        $errors['subject'] = 'Subject is required.';
    }
    if (empty($_POST["message"])) {
        $errors['message'] = 'Message is required.';
    }

    if ($errors) {
        wp_send_json_error($errors);
        wp_die();
    }

    /* sending mail  */

    // if(!empty($_POST['contact_info_email'])){
    //     $to = $_POST['contact_info_email'];
    //     $subject = 'Now message from a client!';
    //     $body  = 'From: ' . $_POST['name'] . '\n';
    //     $body .= 'Email: ' . $_POST['email'] . '\n';
    //     $body .= 'Message: ' . $_POST['message'] . '\n';
    //     $headers = array('Content-Type: text/html; charset=UTF-8');
    //     wp_mail( $to, $subject, $body, $headers );
    // }

    //To Save The Message In Custom Post Type
    $new_post = array(
        'post_title' => $_POST['name'] . $_POST['email'],
        'post_content' => "subject - " . $_POST['subject'] . "<br>" . "message - " . $_POST['message'],
        'post_status' => 'publish',
        'post_type' => THAI_CONTACT_POST_TYPE,
    );
    wp_insert_post($new_post);

    echo 'Thanks You For Contacting Us!';
    wp_die();
}

add_action('wp_ajax_contact_form', 'contact_form');
add_action('wp_ajax_nopriv_contact_form', 'contact_form');
