/* sliders */
let menu = myData.menu;
const swiper = new Swiper(".hero-swiper", {
    effect: 'fade',
    fadeEffect: {
        crossFade: true
    },
    speed: 1500,
    loop: true,
    spaceBetween: -3,
    autoplay: {
        pauseOnMouseEnter: true,
        disableOnInteraction: false,
      },

    // If we need pagination
    pagination: {
        el: '.hero-swiper-pagination',
        clickable: true,
        renderBullet: function (index, className) {
            return `
                    <span class="` + className + `">
                        <!--<img ` + menu[index][0] + `">-->
                    ` +
                menu[index]['icon'] +
                `
                        <h1>
                    ` +
                menu[index]['name'] +
                `
                        </h1>
                        <p>
                    ` +
                menu[index]['description'] +
                `
                        </p>
                    <span x-cloak x-show="showModal" x-transition.opacity class="fixed inset-0 bg-slate-900/20"></span>
                    </span>
                `;
        },
    },
    navigation: {
        nextEl: ".swiper-button-next",
        prevEl: ".swiper-button-prev",
    },
});

// blog swiper
if (window.innerWidth > 768) {
    const sectionSwiper = new Swiper(".swiper-section", {
        slidesPerView: 2,
        spaceBetween: 10,
    });
}
/* youtube video add */


/* add and remove overflow hidden to body for mobile menu */
function updateHeader(open) {
    if (open == true) {
        document.body.classList.add('h-screen', 'overflow-hidden');
    } else {
        document.body.classList.remove('h-screen', 'overflow-hidden');
    }
}

/* navbar on scroll */
// let prevScrollpos = window.pageYOffset;
// window.addEventListener("scroll", () => {
//     let currentScrollPos = window.pageYOffset;
//     let isMobileView = window.matchMedia("(max-width: 767px)").matches;
//     let isAtTop = window.pageYOffset === 0;
//     let logged = myData.logged;
//     if (prevScrollpos > currentScrollPos) {
//         if (logged) {
//             if (isMobileView) {
//                 document.getElementById("navbar").style.top = "0";
//                 if (isAtTop) {
//                     document.getElementById("navbar").style.position = "relative";
//                 } else {
//                     document.getElementById("navbar").style.position = "fixed";
//                 }
//             } else {
//                 document.getElementById("navbar").style.top = "32px";
//             }
//             document.getElementById("navbar").style.transition = " top 0.8s";
//         } else {
//             document.getElementById("navbar").style.transition = " top 0.8s";
//             document.getElementById("navbar").style.top = "0";
//         }
//     } else {
//         // scroll down
//         if (logged) {
//             if (isMobileView) {
//                 document.getElementById("navbar").style.top = "0";
//             } else {
//                 document.getElementById("navbar").style.top = "-50px";
//             }
//         } else {
//             document.getElementById("navbar").style.transition = " top 0.8s";
//             document.getElementById("navbar").style.top = "-76px";
//         }
//     }
//     prevScrollpos = currentScrollPos;
// });