<?php
/*
 * Template Name: Services Template
 */
$content = get_queried_object();
$args = array(
    'taxonomy' => 'service',
    'hide_empty' => false,
    'hierarchical' => true,
);
$terms = get_terms($args);
get_header();
?>
<section class="text-gray-600 body-font">
    <div class="container px-5 py-24 mx-auto">
        <div class="flex flex-wrap -m-4">
            <?php foreach ($terms as $term) :
                $permalink = get_term_link($term->term_id);
                $featured_img = get_field('image', $term->taxonomy . '_' . $term->term_id);
                ?>
                <div class="p-4 md:w-1/3">
                    <div class="h-full border-2 border-gray-200 border-opacity-60 rounded-lg overflow-hidden">
                        <img class="lg:h-48 md:h-36 w-full object-cover object-center"
                             src="<?= $featured_img['url']; ?>" alt="<?= $term->name ?>">
                        <div class="p-6">
                            <h1 class="title-font text-lg font-medium text-gray-900 mb-3"><?= $term->name; ?></h1>
                            <div class="leading-relaxed text-sm mb-3"><?= $term->description; ?></div>
                            <div class="flex items-center flex-wrap ">
                                <a href="<?= $permalink; ?>" class="text-indigo-500 inline-flex items-center md:mb-2 lg:mb-0">Learn More
                                    <svg class="w-4 h-4 ml-2" viewBox="0 0 24 24" stroke="currentColor"
                                         stroke-width="2"
                                         fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M5 12h14"></path>
                                        <path d="M12 5l7 7-7 7"></path>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php get_footer(); ?>