<?php
/*
 * Template Name: Blog Template
 */
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1; // get current page number or default to 1
$args = array(
    'post_type' => 'post',
    'post_status' => 'publish',
    'posts_per_page' => '4',
    'paged' => $paged // current page number
);
$posts = new WP_Query($args);
$index = 1;
get_header();
?>

<section class="px-5 py-10">
    <div class="container grid grid-cols-12 mx-auto max-w-[90rem] gap-y-6">
        <div class="relative flex-col col-span-12 bg-center bg-no-repeat bg-cover min-h-96 md:col-span-8 ">
            <div class="mx-auto max-w-7xl px-6 lg:px-8">
                <div class="mx-auto grid max-w-2xl grid-cols-1 gap-x-8 gap-y-10 lg:mx-0 lg:max-w-none lg:grid-cols-2">
                    <?php foreach ($posts->posts as $post) : $featured_img = wp_get_attachment_url(get_post_thumbnail_id($post->ID)); ?>
                        <article class="flex max-w-xl flex-col items-start p-5">
                            <img class="h-56 w-full mb-3 object-cover rounded-xl" src="<?= $featured_img; ?>" alt="Image Description">
                            <div class="flex items-center gap-x-4 text-xs">
                                <time datetime="2020-03-16" class="text-gray-500">Mar 16, 2020</time>
                                <?php foreach (get_the_category($post->ID) as $cat) : ?>
                                    <a href="<?= get_category_link($cat->term_id); ?>"
                                       class="relative z-10 rounded-full bg-gray-50 px-3 py-1.5 font-medium text-gray-600 hover:bg-mtkn-yellow"><?= $cat->name; ?></a>
                                <?php endforeach; ?>
                            </div>
                            <div class="group relative">
                                <h3 class="mt-3 text-lg font-semibold leading-6 text-gray-900 group-hover:text-mtkn-yellow">
                                    <a href="<?= get_permalink($post->ID); ?>">
                                        <span class="absolute inset-0"></span>
                                        <?= $post->post_title; ?>
                                    </a>
                                </h3>
                                <p class="mt-5 line-clamp-3 text-sm leading-6 text-gray-600"><?= $post->post_excerpt; ?></p>
                            </div>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <!--  blog latest posts  -->
        <div class="hidden col-span-4 py-2 sm:hidden md:block lg:col-span-4 xl:col-span-4">
            <?php get_template_part('inc/category-post'); ?>
            <?php get_template_part('inc/top-post', null, array('r_posts' => $posts->posts, 'index' => $index)); ?>
        </div>
    </div>
    <?php get_template_part('inc/pagination', null, array('services' => $posts)); ?>
</section>

<?php get_footer(); ?>
