<?php extract($args); ?>
<nav id="navbar" class="z-20 w-full px-2 py-1 bg-white border-gray-200 rounded shadow-2xl sm:px-4">
    <div class="container flex flex-wrap items-center justify-between mx-auto">
        <div class="flex flex-wrap items-center justify-start">
            <a class="logo" href="<?= bloginfo('url'); ?>">
                <img src="<?= $home_fields['logo']['url']; ?>" class="" alt="<?= get_bloginfo(); ?>">
            </a>
            <div class="hidden w-full flex items-center md:flex md:w-auto" id="navbar-default">
                <?php if (function_exists(clean_custom_menus())) clean_custom_menus(); ?>
            </div>
        </div>
        <!-- Mobile menu button-->
        <div class="flex items-center md:hidden" x-data="{ open: false }"
             @keydown.window.escape="open = false; updateHeader(open);">
            <button class="relative w-10 h-10 text-gray-500 bg-white focus:outline-none"
                    x-on:click="open = !open; updateHeader(open);">
                <span class="sr-only">Open main menu</span>
                <div class="absolute block w-5 transform -translate-x-1/2 -translate-y-1/2 left-1/2 top-1/2">
                    <span aria-hidden="true"
                          class="block absolute h-0.5 w-5 bg-current transform transition duration-500 ease-in-out"
                          :class="{'rotate-45': open,' -translate-y-1.5': !open }"></span>
                    <span aria-hidden="true"
                          class="block absolute  h-0.5 w-5 bg-current   transform transition duration-500 ease-in-out"
                          :class="{'opacity-0': open } "></span>
                    <span aria-hidden="true"
                          class="block absolute  h-0.5 w-5 bg-current transform  transition duration-500 ease-in-out"
                          :class="{'-rotate-45': open, ' translate-y-1.5': !open}"></span>
                </div>
            </button>
            <!-- mobile menu show -->
            <div x-cloak x-show="open" x-transition.opacity class="fixed inset-0 bg-slate-900/75"></div>
            <div x-cloak x-show="open" x-transition:enter="transition ease-out duration-300"
                 x-transition:enter-start="translate-x-full" x-transition:enter-end="translate-x-0"
                 x-transition:leave="transition ease-in duration-300"
                 x-transition:leave-start="translate-x-0" x-transition:leave-end="translate-x-full"
                 @click.away="open = false"
                 class="fixed inset-y-0 right-0 z-50 w-screen h-[100%] overflow-y-auto max-w-lg bg-white">
                <!--close button-->
                <div class="mx-auto flex h-20 items-center gap-8">
                    <div class="flex flex-1 items-center justify-end">
                        <button @click="open = false; updateHeader(open);"
                                class="py-2 px-2 text-mtkn-dark text-sm  hover:text-mtkn-yellow inline-flex whitespace-nowrap items-center focus:outline-none">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                                 stroke="currentColor" class="w-8 h-8">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                            </svg>
                        </button>
                    </div>
                </div>
                <a class="flex justify-center pl-10" href="<?= bloginfo('url'); ?>">
                    <img src="<?= $home_fields['logo']['url']; ?>" class="w-56" alt="<?= get_bloginfo(); ?>">
                </a>
                <?php if (function_exists(clean_custom_mobile_menus())) clean_custom_mobile_menus(); ?>
                <div class="flex flex-col absolute bottom-0 w-full mb-[20px]">
                    <ul class="flex justify-center gap-6 mt-auto">
                        <li>
                            <a href="<?= $home_fields['facebook_link']; ?>" rel="noreferrer" target="_blank"
                               class="transition hover:text-mtkn-yellow">
                                <span class="sr-only">Facebook</span>

                                <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                                    <?= $home_fields['facebook_icon']; ?>
                                </svg>
                            </a>
                        </li>
                        <li>
                            <a href="<?= $home_fields['instagram_link']; ?>" rel="noreferrer" target="_blank"
                               class="transition hover:text-mtkn-yellow">
                                <span class="sr-only">Instagram</span>

                                <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                                    <?= $home_fields['instagram_icon']; ?>
                                </svg>
                            </a>
                        </li>
                        <li>
                            <a href="<?= $home_fields['twitter_link']; ?>" rel="noreferrer" target="_blank"
                               class="transition hover:text-mtkn-yellow">
                                <span class="sr-only">Twitter</span>

                                <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                                    <?= $home_fields['twitter_icon']; ?>
                                </svg>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- desktop nav -->
        <div class="hidden md:flex">
            <?php get_template_part('inc/search-form', null); ?>
        </div>
    </div>
</nav>