<?php
$terms = get_terms(
    array(
        'taxonomy' => 'brand',
        'number' => 5,
        'hide_empty' => false,
    )
);
?>
<section class="text-gray-600 body-font mx-auto max-w-[69rem]">
    <div class="flex flex-wrap px-2 py-14 max-w-[69rem]">
        <?php foreach ($terms as $term) :$image = get_field('logo', $term) ?>
            <div class="max-w-md mx-auto bg-white rounded-xl shadow-md overflow-hidden md:max-w-2xl my-5 transform transform-gpu translate-y-4 hover:translate-y-0 duration-500 ease-in-out">
                <div class="md:flex">
                    <div class="md:flex-shrink-0">
                        <a href="<?= get_term_link($term); ?>">
                            <img class="h-48 w-full object-cover md:w-48" src="<?= $image['url']; ?>" alt="">
                        </a>
                        <p class="block text-sm sm:hidden"><?= $term->name; ?></p>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</section>