<?php
    $blogs = THAI_BLOG_PAGE;
?>
<section class="mx-auto px-5 py-14 max-w-[69rem]">
    <div class="container flex flex-col sm:flex-row">
        <div class="p-3 sm:w-[30%]">
            <h1 class="text-xl font-bold sm:text-4xl">Our Blog</h1>
            <p class="my-3 text-sm text-gray-600">We are always open for any kind of cooperation and looking for new promising projects</p>
            <a href="<?= get_permalink($blogs); ?>" class="inline-flex items-center gap-1 mt-4 text-sm font-medium text-mtkn-blue group">
                Find out more
                <span aria-hidden="true" class="block transition group-hover:translate-x-0.5"> &rarr; </span>
            </a>
        </div>
        <div class="sm:w-[70%] h-fit swiper-section">
            <div class="flex flex-col p-3 space-y-2 swiper-wrapper sm:flex-row sm:space-y-0 sm:space-x-2">
                <?php query_posts(array('post_type' => 'post', 'orderby' => 'date', 'posts_per_page' => 6));
                if (have_posts()) : while (have_posts()) : the_post();
                ?>
                    <div class="swiper-slide">
                        <a href="<?= get_permalink(); ?>" class="relative block h-64 group">
                            <img alt="Developer" src="<?= get_the_post_thumbnail_url(); ?>" class="absolute inset-0 object-cover w-[95%] h-full rounded-xl transition-opacity group-hover:opacity-50 sm:w-full" />
                            <div class="relative p-4 sm:p-6 lg:p-8">
                                <div class="">
                                    <div class="transition-all transform translate-y-8 opacity-0 group-hover:translate-y-0 group-hover:opacity-100">
                                        <time datetime="2022-10-10" class="block text-xs text-yellow-500"> 10th Oct 2022 </time>
                                        <div class="text-sm"><?= get_the_excerpt(); ?></div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="block w-[95%] mx-auto sm:hidden">
                        <h3 class="text-lg font-semibold leading-6 text-gray-900">
                            <a href="<?= get_permalink(); ?>">
                                <span class="absolute inset-0"></span>
                                <?= the_title(); ?>
                            </a>
                        </h3>
                        <p class="my-2 text-sm text-gray-600"><?= get_the_excerpt(); ?></p>
                    </div>
                    <?php endwhile; ?>
                <?php endif;
                wp_reset_query(); ?>
            </div>
        </div>
    </div>
</section>