<?php extract($args); ?>
<section class="py-20 bg-white mx-auto max-w-[69rem]">
	<div class="container mx-auto px-4 transition-all ease-in-out duration-300">
		<div class="max-w-6xl mx-auto transition-all ease-in-out duration-300">
			<div class="block lg:flex justify-between items-start">
				<div class="w-full lg:w-6/12 mb-5 lg:mb-0">
					<div class="rounded-lg relative overflow-hidden">
						<img src="<?= $about_fields['image']['url'] ?? ''; ?>" alt="heroImage"/>
					</div>
				</div>
				<div class="w-full lg:w-5/12 lg:pt-5">
					<h1 class="transition-all ease-in-out duration-300 text-4xl lg:text-5xl mb-5 text-slate-700 font-bold"><?= $about_fields['hero_heading'] ?? ''; ?></h1>
					<p class="text-slate-500 leading-relaxed mb-10 text-lg"><?= $about_fields['hero_description' ?? '']; ?></p>
					<div class="grid md:grid-cols-2 gap-10 mb-10 lg:mb-0">
						<div class="group">
							<h3 class="text-slate-500 leading-relaxed mb-7"><?= $about_fields['hero_text_left' ?? '']; ?></h3>
							<?php if($about_fields['hero_link_left'] !== ''): ?>
								<p><a class="uppercase group text-[11px] font-bold" href="<?= $about_fields['hero_link_left']; ?>">
									<span class="relative inline-block pb-1 after:transition-transform text-slate-600 after:duration-500 after:ease-out after:absolute after:bottom-0 after:left-0 after:block after:h-[2px] after:w-full after:origin-bottom-right after:scale-x-0 after:bg-blue-500 after:content-[''] after:hover:origin-bottom-left after:hover:scale-x-100">Learn More</span></a>
							</p>
							<?php endif ?>
						</div>
						<div class="group">
							<h3 class="text-slate-500 leading-relaxed mb-7"><?= $about_fields['hero_text_right' ?? '']; ?></h3>
							<?php if($about_fields['hero_link_right'] !== ''): ?>
								<p><a class="uppercase group text-[11px] font-bold" href="<?= $about_fields['hero_link_right']; ?>">
										<span class="relative inline-block pb-1 after:transition-transform text-slate-600 after:duration-500 after:ease-out after:absolute after:bottom-0 after:left-0 after:block after:h-[2px] after:w-full after:origin-bottom-right after:scale-x-0 after:bg-blue-500 after:content-[''] after:hover:origin-bottom-left after:hover:scale-x-100">Learn More</span></a>
								</p>
							<?php endif ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>