<?php
$home_fields = get_fields(THAI_HOME_PAGE);
?>

<footer aria-label="Site Footer" class="bg-mtkn-dark-blue ">
    <div class="max-w-[69rem] px-4 py-16 mx-auto space-y-8 sm:px-6 lg:space-y-16 lg:px-8">
        <div class="sm:flex sm:items-center sm:justify-between">
            <a href="/" class="">
                <img src="<?= $home_fields['logo']['url']; ?>" class="w-20" alt="<?= get_bloginfo(); ?>">
            </a>

            <ul class="flex justify-start gap-6 mt-8 sm:mt-0 sm:justify-end">
                <li>
                    <a href="<?= $home_fields['facebook_link']; ?>" rel="noreferrer" target="_blank" class="text-white transition hover:text-mtkn-yellow">
                        <span class="sr-only">Facebook</span>

                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                            <?= $home_fields['facebook_icon']; ?>
                        </svg>
                    </a>
                </li>

                <li>
                    <a href="<?= $home_fields['instagram_link']; ?>" rel="noreferrer" target="_blank" class="text-white transition hover:text-mtkn-yellow">
                        <span class="sr-only">Instagram</span>

                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                            <?= $home_fields['instagram_icon']; ?>
                        </svg>
                    </a>
                </li>

                <li>
                    <a href="<?= $home_fields['twitter_link']; ?>" rel="noreferrer" target="_blank" class="text-white transition hover:text-mtkn-yellow">
                        <span class="sr-only">Twitter</span>

                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                            <?= $home_fields['twitter_icon']; ?>
                        </svg>
                    </a>
                </li>
            </ul>
        </div>

        <div class="grid grid-cols-1 gap-8 pt-8 border-t border-gray-100 sm:grid-cols-2 lg:grid-cols-4 lg:pt-16">
            <div>
                <p class="font-medium text-white">Services</p>

                <nav aria-label="Footer Navigation - Services" class="mt-6">
                    <ul class="space-y-4 text-sm">
                        <li>
                            <?php
                            $args = array(
                                'theme_location'  => 'footer_service',
                                'container' => false,
                                'menu_class'      => 'space-y-4 text-sm',
                                'add_li_class'  => 'my-2 lg:my-0 ml-4 bg-blue-200 sm:ml-0 footer_menu',
                            );
                            wp_nav_menu($args);
                            ?>
                        </li>
                    </ul>
                </nav>
            </div>

            <div>
                <p class="font-medium text-white">Our Story</p>

                <nav aria-label="Footer Navigation - Company" class="mt-6">
                    <ul class="space-y-4 text-sm">

                        <li>
                            <a href="/about-us#what-we-do" class="text-white transition hover:text-mtkn-yellow">
                                What We Do Best
                            </a>
                        </li>

                        <li>
                            <a href="/about-us#company-status" class="text-white transition hover:text-mtkn-yellow">
                                Company Status
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>

            <div>
                <p class="font-medium text-white">Helpful Links</p>

                <nav aria-label="Footer Navigation - Company" class="mt-6">
                    <ul class="space-y-4 text-sm">
                        <li>
                            <a href="/contact-us#map" class="text-white transition hover:text-mtkn-yellow">
                                Map
                            </a>
                        </li>
                        <li>
                            <a href="/blog" class="text-white transition hover:text-mtkn-yellow">
                                Blogs
                            </a>
                        </li>
                        <li>
                            <a href="/products" class="text-white transition hover:text-mtkn-yellow">
                                Products
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>

            <div>
                <p class="font-medium text-white">Company</p>

                <nav aria-label="Footer Navigation - Legal" class="mt-6">
                    <ul class="">
                        <li>
                            <?php
                            $args = array(
                                'theme_location'  => 'footer',
                                'container' => false,
                                'menu_class'      => 'space-y-4 text-sm',
                                'add_li_class'  => 'my-2 lg:my-0 ml-4 bg-blue-200 sm:ml-0 footer_menu',
                            );
                            wp_nav_menu($args);
                            ?>
                        </li>
                    </ul>
                </nav>
            </div>
        </div>

        <p class="text-xs text-white">
            &copy; 2022. <?php bloginfo('name') ?> . All rights reserved.
        </p>
    </div>
</footer>

<?php wp_footer(); ?>
</body>
</html>