<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('page_descs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('page_id');
            $table->enum('direction', ['rtl', 'ltr'])->default('rtl');
            $table->longText('content')->nullable();
            $table->string('images')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('page_descs');
    }
};
