<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Slider>
 */
class SliderFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'title' => $this->faker->word(),
            'title_color' => $this->faker->colorName(),
            'intro' => $this->faker->paragraph(),
            'intro_color' => $this->faker->colorName(),
            'button_color' => $this->faker->colorName(),
            'url' => "/products"
        ];
    }
}
