<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = ['partner_id', 'name', 'slug', 'intro', 'desc'];


    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function productCategories()
    {
        return $this->belongsToMany(ProductCategory::class);
    }

    public function productImages()
    {
        return $this->belongsToMany(ProductImage::class);
    }

    public function productVariation()
    {
        return $this->belongsToMany(ProductVariation::class);
    }
}
