<?php

namespace App\Livewire\Backend\User;

use App\Models\Role;
use App\Models\User;
use Illuminate\Validation\Rule;
use Livewire\Attributes\Layout;
use Livewire\Attributes\On;
use Livewire\Attributes\Title;
use Livewire\Component;

class EditUser extends Component
{
    #[Title('Edit User')]
    #[Layout('layouts.admin')]
    public $user;
    public $id;
    public $name;
    public $email;
    public $selectedRoles = [];
    public $roles;

    public function mount($id)
    {
        $this->refreshRoles();
        $user = User::findOrFail($id);
        $this->user = $user;
        $this->name = $user->name;
        $this->email = $user->email;
        $this->selectedRoles = $user->roles->pluck('id')->toArray();
    }

    #[On('roleAdded')]
    public function refreshRoles()
    {
        $this->roles = Role::all(['id', 'name']);
        $newRole = $this->roles->last();
        if (!in_array($newRole->id, $this->selectedRoles)) {
            $this->selectedRoles[] = $newRole->id;
        }
    }

    public function update() {
        $validated = $this->validate([
            'name' => 'sometimes|required|string',
            'email' => ['sometimes', 'required', 'email', Rule::unique('users')->ignore($this->id)],
        ]);
        if($validated) {
            $this->user->update($validated);
        }

        $this->user->roles()->sync($this->selectedRoles);
        return $this->redirect(route('admin-users'), navigate:true);
    }

    public function render()
    {
        return view('livewire.backend.user.edit-user');
    }
}
