<?php

namespace App\Http\Requests\Page;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdatePageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $pageId = $this->route('page')->id;
        return [
            'featured_image' => 'nullable|image',
            'title' => 'sometimes|required|string',
            'slug' => ['sometimes', 'required', Rule::unique('pages')->ignore($pageId)],
            'intro' => 'nullable'
        ];
    }
}
